(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     26778,        609]*)
(*NotebookOutlinePosition[     27622,        636]*)
(*  CellTagsIndexPosition[     27578,        632]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(\(\( (*\ 
      Example\ 4.3  .2\ *) \)\(\[IndentingNewLine]\)\(k[x_, 
          s_] := \ \(-1\)/\((\[Pi]\ *\((1.  + \((x - 
                        s)\)^2)\)\ )\);\)\(\ \)\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
    \( (*\ Use\ trapezoidal\ rule\ n = 
        8\ *) \[IndentingNewLine]\(x = {\(-1\), \(-3\)/4, \ \(-1\)/
            2, \ \(-1\)/4, \ 0, \ 1/4, \ 1/2, \ 3/4, \ 
          1};\)\), "\[IndentingNewLine]", 
    \(\(s = \ {\(-1\), \(-3\)/4, \ \(-1\)/2, \ \(-1\)/4, \ 0, \ 1/4, \ 1/2, \ 
          3/4, \ 1};\)\), "\[IndentingNewLine]", 
    \(matk = Table[k[x[\([i]\)], s[\([j]\)]], \ {i, 9}, {j, 9}]\)}], "Input"],

Cell[BoxData[
    \({{0.3183098861837907`, 0.31707132631537127`, 0.3134128110117324`, 
        0.30749936174736003`, 0.29958577523180296`, 0.2899905012919944`, 
        0.2790662015857891`, 0.2671715766001653`, 
        0.25464790894703254`}, {0.31707132631537127`, 0.3183098861837907`, 
        0.31707132631537127`, 0.3134128110117324`, 0.30749936174736003`, 
        0.29958577523180296`, 0.2899905012919944`, 0.2790662015857891`, 
        0.2671715766001653`}, {0.3134128110117324`, 0.31707132631537127`, 
        0.3183098861837907`, 0.31707132631537127`, 0.3134128110117324`, 
        0.30749936174736003`, 0.29958577523180296`, 0.2899905012919944`, 
        0.2790662015857891`}, {0.30749936174736003`, 0.3134128110117324`, 
        0.31707132631537127`, 0.3183098861837907`, 0.31707132631537127`, 
        0.3134128110117324`, 0.30749936174736003`, 0.29958577523180296`, 
        0.2899905012919944`}, {0.29958577523180296`, 0.30749936174736003`, 
        0.3134128110117324`, 0.31707132631537127`, 0.3183098861837907`, 
        0.31707132631537127`, 0.3134128110117324`, 0.30749936174736003`, 
        0.29958577523180296`}, {0.2899905012919944`, 0.29958577523180296`, 
        0.30749936174736003`, 0.3134128110117324`, 0.31707132631537127`, 
        0.3183098861837907`, 0.31707132631537127`, 0.3134128110117324`, 
        0.30749936174736003`}, {0.2790662015857891`, 0.2899905012919944`, 
        0.29958577523180296`, 0.30749936174736003`, 0.3134128110117324`, 
        0.31707132631537127`, 0.3183098861837907`, 0.31707132631537127`, 
        0.3134128110117324`}, {0.2671715766001653`, 0.2790662015857891`, 
        0.2899905012919944`, 0.29958577523180296`, 0.30749936174736003`, 
        0.3134128110117324`, 0.31707132631537127`, 0.3183098861837907`, 
        0.31707132631537127`}, {0.25464790894703254`, 0.2671715766001653`, 
        0.2790662015857891`, 0.2899905012919944`, 0.29958577523180296`, 
        0.30749936174736003`, 0.3134128110117324`, 0.31707132631537127`, 
        0.3183098861837907`}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(d = {{1/8, 0, 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
            0}, \[IndentingNewLine]{0, 1/4, 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
            0}, \[IndentingNewLine]{0, 0, 1/4, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
            0}, \[IndentingNewLine]{0, 0, 0, \ 1/4, \ 0, \ 0, \ 0, \ 0, \ 
            0}, \[IndentingNewLine]{0, 0, 0, \ 0, \ 1/4, \ 0, \ 0, \ 0, \ 
            0}, \[IndentingNewLine]{0, 0, 0, \ 0, \ 0, \ 1/4, \ 0, \ 0, \ 
            0}, \[IndentingNewLine]{0, 0, 0, \ 0, \ 0, \ 0, \ 1/4, \ 0, \ 
            0}, \[IndentingNewLine]{0, 0, 0, \ 0, \ 0, \ 0, \ 0, \ 1/4, \ 
            0}, \[IndentingNewLine]{0, 0, 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
            1/8}};\)\), "\[IndentingNewLine]", 
    \(a = matk\  . d\)}], "Input"],

Cell[BoxData[
    \({{0.039788735772973836`, 0.07926783157884282`, 0.0783532027529331`, 
        0.07687484043684001`, 0.07489644380795074`, 0.0724976253229986`, 
        0.06976655039644727`, 0.06679289415004132`, 
        0.03183098861837907`}, {0.03963391578942141`, 0.07957747154594767`, 
        0.07926783157884282`, 0.0783532027529331`, 0.07687484043684001`, 
        0.07489644380795074`, 0.0724976253229986`, 0.06976655039644727`, 
        0.03339644707502066`}, {0.03917660137646655`, 0.07926783157884282`, 
        0.07957747154594767`, 0.07926783157884282`, 0.0783532027529331`, 
        0.07687484043684001`, 0.07489644380795074`, 0.0724976253229986`, 
        0.03488327519822364`}, {0.038437420218420004`, 0.0783532027529331`, 
        0.07926783157884282`, 0.07957747154594767`, 0.07926783157884282`, 
        0.0783532027529331`, 0.07687484043684001`, 0.07489644380795074`, 
        0.0362488126614993`}, {0.03744822190397537`, 0.07687484043684001`, 
        0.0783532027529331`, 0.07926783157884282`, 0.07957747154594767`, 
        0.07926783157884282`, 0.0783532027529331`, 0.07687484043684001`, 
        0.03744822190397537`}, {0.0362488126614993`, 0.07489644380795074`, 
        0.07687484043684001`, 0.0783532027529331`, 0.07926783157884282`, 
        0.07957747154594767`, 0.07926783157884282`, 0.0783532027529331`, 
        0.038437420218420004`}, {0.03488327519822364`, 0.0724976253229986`, 
        0.07489644380795074`, 0.07687484043684001`, 0.0783532027529331`, 
        0.07926783157884282`, 0.07957747154594767`, 0.07926783157884282`, 
        0.03917660137646655`}, {0.03339644707502066`, 0.06976655039644727`, 
        0.0724976253229986`, 0.07489644380795074`, 0.07687484043684001`, 
        0.0783532027529331`, 0.07926783157884282`, 0.07957747154594767`, 
        0.03963391578942141`}, {0.03183098861837907`, 0.06679289415004132`, 
        0.06976655039644727`, 0.0724976253229986`, 0.07489644380795074`, 
        0.07687484043684001`, 0.0783532027529331`, 0.07926783157884282`, 
        0.039788735772973836`}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(c = \[Mu]\ {{1, 0, 0, 0, 0, 0, 0, 0, 0}, \ \[IndentingNewLine]{0, 1, 
              0, 0, 0, 0, 0, 0, 0}, \[IndentingNewLine]{0, 0, 1, 0, 0, 0, 0, 
              0, 0}, \[IndentingNewLine]{0, 0, 0, 1, 0, 0, 0, 0, 
              0}, \[IndentingNewLine]{0, 0, 0, 0, 1, 0, 0, 0, 
              0}, \[IndentingNewLine]{0, 0, 0, 0, 0, 1, 0, 0, 
              0}, \[IndentingNewLine]{0, 0, 0, 0, 0, 0, 1, 0, 
              0}, \[IndentingNewLine]{0, 0, 0, 0, 0, 0, 0, 1, 
              0}, \[IndentingNewLine]{0, 0, 0, 0, 0, 0, 0, 0, 
              1}};\)\), "\[IndentingNewLine]", 
    \(b = a - c\)}], "Input"],

Cell[BoxData[
    \({{\(\(0.039788735772973836`\)\(\[InvisibleSpace]\)\) - \[Mu], 
        0.07926783157884282`, 0.0783532027529331`, 0.07687484043684001`, 
        0.07489644380795074`, 0.0724976253229986`, 0.06976655039644727`, 
        0.06679289415004132`, 
        0.03183098861837907`}, {0.03963391578942141`, \
\(\(0.07957747154594767`\)\(\[InvisibleSpace]\)\) - \[Mu], 
        0.07926783157884282`, 0.0783532027529331`, 0.07687484043684001`, 
        0.07489644380795074`, 0.0724976253229986`, 0.06976655039644727`, 
        0.03339644707502066`}, {0.03917660137646655`, 
        0.07926783157884282`, \(\(0.07957747154594767`\)\(\[InvisibleSpace]\)\
\) - \[Mu], 0.07926783157884282`, 0.0783532027529331`, 0.07687484043684001`, 
        0.07489644380795074`, 0.0724976253229986`, 
        0.03488327519822364`}, {0.038437420218420004`, 0.0783532027529331`, 
        0.07926783157884282`, \(\(0.07957747154594767`\)\(\[InvisibleSpace]\)\
\) - \[Mu], 0.07926783157884282`, 0.0783532027529331`, 0.07687484043684001`, 
        0.07489644380795074`, 0.0362488126614993`}, {0.03744822190397537`, 
        0.07687484043684001`, 0.0783532027529331`, 
        0.07926783157884282`, \(\(0.07957747154594767`\)\(\[InvisibleSpace]\)\
\) - \[Mu], 0.07926783157884282`, 0.0783532027529331`, 0.07687484043684001`, 
        0.03744822190397537`}, {0.0362488126614993`, 0.07489644380795074`, 
        0.07687484043684001`, 0.0783532027529331`, 
        0.07926783157884282`, \(\(0.07957747154594767`\)\(\[InvisibleSpace]\)\
\) - \[Mu], 0.07926783157884282`, 0.0783532027529331`, 
        0.038437420218420004`}, {0.03488327519822364`, 0.0724976253229986`, 
        0.07489644380795074`, 0.07687484043684001`, 0.0783532027529331`, 
        0.07926783157884282`, \(\(0.07957747154594767`\)\(\[InvisibleSpace]\)\
\) - \[Mu], 0.07926783157884282`, 
        0.03917660137646655`}, {0.03339644707502066`, 0.06976655039644727`, 
        0.0724976253229986`, 0.07489644380795074`, 0.07687484043684001`, 
        0.0783532027529331`, 
        0.07926783157884282`, \(\(0.07957747154594767`\)\(\[InvisibleSpace]\)\
\) - \[Mu], 0.03963391578942141`}, {0.03183098861837907`, 
        0.06679289415004132`, 0.06976655039644727`, 0.0724976253229986`, 
        0.07489644380795074`, 0.07687484043684001`, 0.0783532027529331`, 
        0.07926783157884282`, \
\(\(0.039788735772973836`\)\(\[InvisibleSpace]\)\) - \[Mu]}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[Det[b] \[Equal] \ 0, \ \[Mu]]\)], "Input"],

Cell[BoxData[
    \({{\[Mu] \[Rule] \(-6.237461694845822`*^-8\) - 
            8.43317189583417`*^-8\ \[ImaginaryI]}, {\[Mu] \[Rule] \
\(-6.237461694845822`*^-8\) + 
            8.43317189583417`*^-8\ \[ImaginaryI]}, {\[Mu] \[Rule] 
          9.414041901149043`*^-8 - 
            5.831778421101837`*^-8\ \[ImaginaryI]}, {\[Mu] \[Rule] 
          9.414041901149043`*^-8 + 
            5.831778421101837`*^-8\ \[ImaginaryI]}, {\[Mu] \[Rule] 
          1.7147671196922753`*^-6}, {\[Mu] \[Rule] 
          0.00004074124513902533`}, {\[Mu] \[Rule] 
          0.0009799484931491723`}, {\[Mu] \[Rule] 
          0.02363316201221191`}, {\[Mu] \[Rule] 
          0.6119641423183575`}}\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \( (*\ These\ are\ the\ characteristic\ values\ *) \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
    \( (*\ 
      To\ find\ the\ solution\ we\ shall\ solve\ the\ system\
\[IndentingNewLine]phitil[i\ h - 1] - \ 
        h*Sum \*"\"\<{j=0}^9 phitil[jh-1]*k[i,j]=1 ,\nwhere n=8,  h=1/4, i=0, \
1, ..., 8.\nTake y1=phil[-1], y2=phil[-3/4], and so on, y9=phil[1] \>"*) \
\[IndentingNewLine]\(h = 1/4;\)\), "\[IndentingNewLine]", 
    \(\(k[i_, j_] := 
        1/\((\[Pi]*\((\ 
                1.  + \((i - j)\)^2\ h^2)\))\);\)\), "\[IndentingNewLine]", 
    \(y1 - 0.5*h*y1*k[0, 0] - h*y2*k[0, 1] - h*y3*k[0, 2] - h*y4*k[0, 3] - 
      h*y5*k[0, 4] - h*y6*k[0, 5] - h*y7*k[0, 6] - h*y8*k[0, 7] - 
      0.5*y9*k[0, 8]\)}], "Input"],

Cell[BoxData[
    \(0.9602112642270262`\ y1 - 0.07489644380795074`\ y2 - 
      0.06366197723675814`\ y3 - 0.05092958178940651`\ y4 - 
      0.039788735772973836`\ y5 - 0.031054623042321046`\ y6 - 
      0.024485375860291588`\ y7 - 0.019588300688233275`\ y8 - 
      0.03183098861837907`\ y9\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(y1 - 0.5*h*y1*k[1, 0] - h*y2*k[1, 1] - h*y3*k[1, 2] - h*y4*k[1, 3] - 
      h*y5*k[1, 4] - h*y6*k[1, 5] - h*y7*k[1, 6] - h*y8*k[1, 7] - 
      0.5*y9*k[1, 8]\)], "Input"],

Cell[BoxData[
    \(0.9625517780960247`\ y1 - 0.07957747154594767`\ y2 - 
      0.07489644380795074`\ y3 - 0.06366197723675814`\ y4 - 
      0.05092958178940651`\ y5 - 0.039788735772973836`\ y6 - 
      0.031054623042321046`\ y7 - 0.024485375860291588`\ y8 - 
      0.03917660137646655`\ y9\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(y1 - 0.5*h*y1*k[2, 0] - h*y2*k[2, 1] - h*y3*k[2, 2] - h*y4*k[2, 3] - 
      h*y5*k[2, 4] - h*y6*k[2, 5] - h*y7*k[2, 6] - h*y8*k[2, 7] - 
      0.5*y9*k[2, 8]\)], "Input"],

Cell[BoxData[
    \(0.9681690113816209`\ y1 - 0.07489644380795074`\ y2 - 
      0.07957747154594767`\ y3 - 0.07489644380795074`\ y4 - 
      0.06366197723675814`\ y5 - 0.05092958178940651`\ y6 - 
      0.039788735772973836`\ y7 - 0.031054623042321046`\ y8 - 
      0.048970751720583176`\ y9\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(y1 - 0.5*h*y1*k[3, 0] - h*y2*k[3, 1] - h*y3*k[3, 2] - h*y4*k[3, 3] - 
      h*y5*k[3, 4] - h*y6*k[3, 5] - h*y7*k[3, 6] - h*y8*k[3, 7] - 
      0.5*y9*k[3, 8]\)], "Input"],

Cell[BoxData[
    \(0.9745352091052968`\ y1 - 0.06366197723675814`\ y2 - 
      0.07489644380795074`\ y3 - 0.07957747154594767`\ y4 - 
      0.07489644380795074`\ y5 - 0.06366197723675814`\ y6 - 
      0.05092958178940651`\ y7 - 0.039788735772973836`\ y8 - 
      0.06210924608464209`\ y9\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(y1 - 0.5*h*y1*k[4, 0] - h*y2*k[4, 1] - h*y3*k[4, 2] - h*y4*k[4, 3] - 
      h*y5*k[4, 4] - h*y6*k[4, 5] - h*y7*k[4, 6] - h*y8*k[4, 7] - 
      0.5*y9*k[4, 8]\)], "Input"],

Cell[BoxData[
    \(0.9801056321135131`\ y1 - 0.05092958178940651`\ y2 - 
      0.06366197723675814`\ y3 - 0.07489644380795074`\ y4 - 
      0.07957747154594767`\ y5 - 0.07489644380795074`\ y6 - 
      0.06366197723675814`\ y7 - 0.05092958178940651`\ y8 - 
      0.07957747154594767`\ y9\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(y1 - 0.5*h*y1*k[5, 0] - h*y2*k[5, 1] - h*y3*k[5, 2] - h*y4*k[5, 3] - 
      h*y5*k[5, 4] - h*y6*k[5, 5] - h*y7*k[5, 6] - h*y8*k[5, 7] - 
      0.5*y9*k[5, 8]\)], "Input"],

Cell[BoxData[
    \(0.9844726884788395`\ y1 - 0.039788735772973836`\ y2 - 
      0.05092958178940651`\ y3 - 0.06366197723675814`\ y4 - 
      0.07489644380795074`\ y5 - 0.07957747154594767`\ y6 - 
      0.07489644380795074`\ y7 - 0.06366197723675814`\ y8 - 
      0.10185916357881301`\ y9\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(y1 - 0.5*h*y1*k[6, 0] - h*y2*k[6, 1] - h*y3*k[6, 2] - h*y4*k[6, 3] - 
      h*y5*k[6, 4] - h*y6*k[6, 5] - h*y7*k[6, 6] - h*y8*k[6, 7] - 
      0.5*y9*k[6, 8]\)], "Input"],

Cell[BoxData[
    \(0.9877573120698542`\ y1 - 0.031054623042321046`\ y2 - 
      0.039788735772973836`\ y3 - 0.05092958178940651`\ y4 - 
      0.06366197723675814`\ y5 - 0.07489644380795074`\ y6 - 
      0.07957747154594767`\ y7 - 0.07489644380795074`\ y8 - 
      0.12732395447351627`\ y9\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(y1 - 0.5*h*y1*k[7, 0] - h*y2*k[7, 1] - h*y3*k[7, 2] - h*y4*k[7, 3] - 
      h*y5*k[7, 4] - h*y6*k[7, 5] - h*y7*k[7, 6] - h*y8*k[7, 7] - 
      0.5*y9*k[7, 8]\)], "Input"],

Cell[BoxData[
    \(0.9902058496558833`\ y1 - 0.024485375860291588`\ y2 - 
      0.031054623042321046`\ y3 - 0.039788735772973836`\ y4 - 
      0.05092958178940651`\ y5 - 0.06366197723675814`\ y6 - 
      0.07489644380795074`\ y7 - 0.07957747154594767`\ y8 - 
      0.14979288761590148`\ y9\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(y1 - 0.5*h*y1*k[8, 0] - h*y2*k[8, 1] - h*y3*k[8, 2] - h*y4*k[8, 3] - 
      h*y5*k[8, 4] - h*y6*k[8, 5] - h*y7*k[8, 6] - h*y8*k[8, 7] - 
      0.5*y9*k[8, 8]\)], "Input"],

Cell[BoxData[
    \(0.9920422528454053`\ y1 - 0.019588300688233275`\ y2 - 
      0.024485375860291588`\ y3 - 0.031054623042321046`\ y4 - 
      0.039788735772973836`\ y5 - 0.05092958178940651`\ y6 - 
      0.06366197723675814`\ y7 - 0.07489644380795074`\ y8 - 
      0.15915494309189535`\ y9\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[{0.9602112642270262`\ y1 - 0.07489644380795074`\ y2 - 
            0.06366197723675814`\ y3 - 0.05092958178940651`\ y4 - 
            0.039788735772973836`\ y5 - 0.031054623042321046`\ y6 - 
            0.024485375860291588`\ y7 - 0.019588300688233275`\ y8 - 
            0.03183098861837907`\ y9 \[Equal] 
          1, \[IndentingNewLine]0.9625517780960247`\ y1 - 
            0.07957747154594767`\ y2 - 0.07489644380795074`\ y3 - 
            0.06366197723675814`\ y4 - 0.05092958178940651`\ y5 - 
            0.039788735772973836`\ y6 - 0.031054623042321046`\ y7 - 
            0.024485375860291588`\ y8 - 0.03917660137646655`\ y9 \[Equal] 
          1, \[IndentingNewLine]0.9681690113816209`\ y1 - 
            0.07489644380795074`\ y2 - 0.07957747154594767`\ y3 - 
            0.07489644380795074`\ y4 - 0.06366197723675814`\ y5 - 
            0.05092958178940651`\ y6 - 0.039788735772973836`\ y7 - 
            0.031054623042321046`\ y8 - 0.048970751720583176`\ y9 \[Equal] 
          1, \[IndentingNewLine]0.9745352091052968`\ y1 - 
            0.06366197723675814`\ y2 - 0.07489644380795074`\ y3 - 
            0.07957747154594767`\ y4 - 0.07489644380795074`\ y5 - 
            0.06366197723675814`\ y6 - 0.05092958178940651`\ y7 - 
            0.039788735772973836`\ y8 - 0.06210924608464209`\ y9 \[Equal] 
          1, \[IndentingNewLine]0.9801056321135131`\ y1 - 
            0.05092958178940651`\ y2 - 0.06366197723675814`\ y3 - 
            0.07489644380795074`\ y4 - 0.07957747154594767`\ y5 - 
            0.07489644380795074`\ y6 - 0.06366197723675814`\ y7 - 
            0.05092958178940651`\ y8 - 0.07957747154594767`\ y9 \[Equal] 
          1, \[IndentingNewLine]0.9844726884788395`\ y1 - 
            0.039788735772973836`\ y2 - 0.05092958178940651`\ y3 - 
            0.06366197723675814`\ y4 - 0.07489644380795074`\ y5 - 
            0.07957747154594767`\ y6 - 0.07489644380795074`\ y7 - 
            0.06366197723675814`\ y8 - 0.10185916357881301`\ y9 \[Equal] 
          1, \[IndentingNewLine]0.9877573120698542`\ y1 - 
            0.031054623042321046`\ y2 - 0.039788735772973836`\ y3 - 
            0.05092958178940651`\ y4 - 0.06366197723675814`\ y5 - 
            0.07489644380795074`\ y6 - 0.07957747154594767`\ y7 - 
            0.07489644380795074`\ y8 - 0.12732395447351627`\ y9 \[Equal] 
          1, \[IndentingNewLine]0.9902058496558833`\ y1 - 
            0.024485375860291588`\ y2 - 0.031054623042321046`\ y3 - 
            0.039788735772973836`\ y4 - 0.05092958178940651`\ y5 - 
            0.06366197723675814`\ y6 - 0.07489644380795074`\ y7 - 
            0.07957747154594767`\ y8 - 0.14979288761590148`\ y9 \[Equal] 
          1, \[IndentingNewLine]0.9920422528454053`\ y1 - 
            0.019588300688233275`\ y2 - 0.024485375860291588`\ y3 - 
            0.031054623042321046`\ y4 - 0.039788735772973836`\ y5 - 
            0.05092958178940651`\ y6 - 0.06366197723675814`\ y7 - 
            0.07489644380795074`\ y8 - 0.15915494309189535`\ y9 \[Equal] 
          1}, \ \[IndentingNewLine]{y1, \ y2, \ y3, \ y4, \ y5, \ y6, \ y7, \ 
        y8, \ y9}]\)], "Input"],

Cell[BoxData[
    \({{y1 \[Rule] 1.0203290853943034`, y2 \[Rule] \(-0.8099992070418743`\), 
        y3 \[Rule] 0.9408552363157536`, y4 \[Rule] \(-0.8481278058178381`\), 
        y5 \[Rule] 0.8732047553017281`, y6 \[Rule] \(-0.8481278058176944`\), 
        y7 \[Rule] 0.9408552363155382`, y8 \[Rule] \(-0.8099992070417081`\), 
        y9 \[Rule] 0.2550822713485471`}}\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \( (*\ 
      To\ find\ the\ solution\ we\ solve\ the\ \
system\[IndentingNewLine]phitil[i\ h - 1] - \ 
        h*Sum \*"\"\<{j=0}^9 phitil[jh-1]*k[i,j]=1 ,\nwhere n=8,  h=1/4, i=0, \
1, ..., 8.\nBut because of symmetry we shall solve the problem over the \
interval (0,1). \nTake y1=phitil[0], y2=phitil[1/4], y3=phitil[1/2],\n\
y4=phitil[3/4], y5=phitil[1] \>"*) \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(h = 1/4;\)\), "\[IndentingNewLine]", 
    \(\(k[i_, j_] := 
        1/\((\[Pi]*\((\ 
                1.  + \((i - j)\)^2\ h^2)\))\);\)\), "\[IndentingNewLine]", 
    \(y1 - 0.5*h*y1*k[0, 0] - h*y2*k[0, 1] - h*y3*k[0, 2] - h*y4*k[0, 3] - 
      h*y5*k[0, 4]\)}], "Input"],

Cell[BoxData[
    \(0.9602112642270262`\ y1 - 0.07489644380795074`\ y2 - 
      0.06366197723675814`\ y3 - 0.05092958178940651`\ y4 - 
      0.039788735772973836`\ y5\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(y1 - 0.5*h*y1*k[1, 0] - h*y2*k[1, 1] - h*y3*k[1, 2] - h*y4*k[1, 3] - 
      h*y5*k[1, 4]\)], "Input"],

Cell[BoxData[
    \(0.9625517780960247`\ y1 - 0.07957747154594767`\ y2 - 
      0.07489644380795074`\ y3 - 0.06366197723675814`\ y4 - 
      0.05092958178940651`\ y5\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(y1 - 0.5*h*y1*k[2, 0] - h*y2*k[2, 1] - h*y3*k[2, 2] - h*y4*k[2, 3] - 
      h*y5*k[2, 4]\)], "Input"],

Cell[BoxData[
    \(0.9681690113816209`\ y1 - 0.07489644380795074`\ y2 - 
      0.07957747154594767`\ y3 - 0.07489644380795074`\ y4 - 
      0.06366197723675814`\ y5\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(y1 - 0.5*h*y1*k[3, 0] - h*y2*k[3, 1] - h*y3*k[3, 2] - h*y4*k[3, 3] - 
      h*y5*k[3, 4]\)], "Input"],

Cell[BoxData[
    \(0.9745352091052968`\ y1 - 0.06366197723675814`\ y2 - 
      0.07489644380795074`\ y3 - 0.07957747154594767`\ y4 - 
      0.07489644380795074`\ y5\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(y1 - 0.5*h*y1*k[4, 0] - h*y2*k[4, 1] - h*y3*k[4, 2] - h*y4*k[4, 3] - 
      h*y5*k[4, 4]\)], "Input"],

Cell[BoxData[
    \(0.9801056321135131`\ y1 - 0.05092958178940651`\ y2 - 
      0.06366197723675814`\ y3 - 0.07489644380795074`\ y4 - 
      0.07957747154594767`\ y5\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[\[IndentingNewLine]{0.9602112642270262`\ y1\  - 
            0.07489644380795074`\ y2 - 0.06366197723675814`\ y3 - 
            0.05092958178940651`\ y4 - 0.039788735772973836`\ y5 \[Equal] 
          1, \[IndentingNewLine]0.9625517780960247`\ y1 - 
            0.07957747154594767`\ y2 - 0.07489644380795074`\ y3 - 
            0.06366197723675814`\ y4 - 0.05092958178940651`\ y5 \[Equal] 
          1, \[IndentingNewLine]0.9681690113816209`\ y1 - 
            0.07489644380795074`\ y2 - 0.07957747154594767`\ y3 - 
            0.07489644380795074`\ y4 - 0.06366197723675814`\ y5 \[Equal] 
          1, \[IndentingNewLine]0.9745352091052968`\ y1 - 
            0.06366197723675814`\ y2 - 0.07489644380795074`\ y3 - 
            0.07957747154594767`\ y4 - 0.07489644380795074`\ y5 \[Equal] 
          1, \[IndentingNewLine]0.9801056321135131`\ y1 - 
            0.05092958178940651`\ y2 - 0.06366197723675814`\ y3 - 
            0.07489644380795074`\ y4 - 0.07957747154594767`\ y5 \[Equal] 
          1}, \[IndentingNewLine]{y1, y2, y3, y4, y5}]\)], "Input"],

Cell[BoxData[
    \({{y1 \[Rule] 1.0186440572507067`, y2 \[Rule] \(-0.8658474486629627`\), 
        y3 \[Rule] 1.0492033789680157`, y4 \[Rule] \(-0.8658474486629593`\), 
        y5 \[Rule] 0.5093220286253518`}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(matk = Table[k[i, j], \ {i, 5}, {j, 5}]\)], "Input"],

Cell[BoxData[
    \({{0.3183098861837907`, 0.29958577523180296`, 0.25464790894703254`, 
        0.20371832715762603`, 0.15915494309189535`}, {0.29958577523180296`, 
        0.3183098861837907`, 0.29958577523180296`, 0.25464790894703254`, 
        0.20371832715762603`}, {0.25464790894703254`, 0.29958577523180296`, 
        0.3183098861837907`, 0.29958577523180296`, 
        0.25464790894703254`}, {0.20371832715762603`, 0.25464790894703254`, 
        0.29958577523180296`, 0.3183098861837907`, 
        0.29958577523180296`}, {0.15915494309189535`, 0.20371832715762603`, 
        0.25464790894703254`, 0.29958577523180296`, 
        0.3183098861837907`}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(d = {{1/8, 0, 0, 0, 0}, {0, 1/4, 0, 0, 0}, {0, 0, 1/4, 0, 0}, {0, 0, 0, 
          1/4, 0}, {0, 0, 0, 0, 1/8}}\)], "Input"],

Cell[BoxData[
    \({{1\/8, 0, 0, 0, 0}, {0, 1\/4, 0, 0, 0}, {0, 0, 1\/4, 0, 0}, {0, 0, 0, 
        1\/4, 0}, {0, 0, 0, 0, 1\/8}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(a = matk . d\)], "Input"],

Cell[BoxData[
    \({{0.039788735772973836`, 0.07489644380795074`, 0.06366197723675814`, 
        0.05092958178940651`, 0.019894367886486918`}, {0.03744822190397537`, 
        0.07957747154594767`, 0.07489644380795074`, 0.06366197723675814`, 
        0.025464790894703253`}, {0.03183098861837907`, 0.07489644380795074`, 
        0.07957747154594767`, 0.07489644380795074`, 
        0.03183098861837907`}, {0.025464790894703253`, 0.06366197723675814`, 
        0.07489644380795074`, 0.07957747154594767`, 
        0.03744822190397537`}, {0.019894367886486918`, 0.05092958178940651`, 
        0.06366197723675814`, 0.07489644380795074`, 
        0.039788735772973836`}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(b = IdentityMatrix[5] - a\)], "Input"],

Cell[BoxData[
    \({{0.9602112642270262`, \(-0.07489644380795074`\), \
\(-0.06366197723675814`\), \(-0.05092958178940651`\), \
\(-0.019894367886486918`\)}, {\(-0.03744822190397537`\), 
        0.9204225284540524`, \(-0.07489644380795074`\), \
\(-0.06366197723675814`\), \(-0.025464790894703253`\)}, \
{\(-0.03183098861837907`\), \(-0.07489644380795074`\), 
        0.9204225284540524`, \(-0.07489644380795074`\), \
\(-0.03183098861837907`\)}, {\(-0.025464790894703253`\), \
\(-0.06366197723675814`\), \(-0.07489644380795074`\), 
        0.9204225284540524`, \(-0.03744822190397537`\)}, \
{\(-0.019894367886486918`\), \(-0.05092958178940651`\), \
\(-0.06366197723675814`\), \(-0.07489644380795074`\), 
        0.9602112642270262`}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(rightside = {1, 1, 1, 1, 1}\)], "Input"],

Cell[BoxData[
    \({1, 1, 1, 1, 1}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(LinearSolve[b, rightside]\)], "Input"],

Cell[BoxData[
    \({1.3444602306628095`, 1.3887756796332253`, 1.4054628998227057`, 
      1.3887756796332251`, 1.34446023066281`}\)], "Output"]
}, Open  ]]
},
FrontEndVersion->"4.0 for Macintosh",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{520, 482},
WindowMargins->{{25, Automatic}, {32, Automatic}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1717, 49, 207, 4, 43, "Input"],

Cell[CellGroupData[{
Cell[1949, 57, 428, 7, 75, "Input"],
Cell[2380, 66, 2036, 28, 281, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4453, 99, 748, 11, 171, "Input"],
Cell[5204, 112, 2061, 28, 281, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7302, 145, 629, 10, 171, "Input"],
Cell[7934, 157, 2410, 36, 281, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10381, 198, 68, 1, 27, "Input"],
Cell[10452, 201, 690, 13, 111, "Output"]
}, Open  ]],
Cell[11157, 217, 82, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[11264, 222, 645, 12, 203, "Input"],
Cell[11912, 236, 305, 5, 56, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12254, 246, 190, 3, 59, "Input"],
Cell[12447, 251, 304, 5, 56, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12788, 261, 190, 3, 59, "Input"],
Cell[12981, 266, 304, 5, 56, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[13322, 276, 190, 3, 59, "Input"],
Cell[13515, 281, 302, 5, 56, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[13854, 291, 190, 3, 59, "Input"],
Cell[14047, 296, 301, 5, 56, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14385, 306, 190, 3, 59, "Input"],
Cell[14578, 311, 302, 5, 56, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14917, 321, 190, 3, 59, "Input"],
Cell[15110, 326, 303, 5, 56, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[15450, 336, 190, 3, 59, "Input"],
Cell[15643, 341, 304, 5, 56, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[15984, 351, 190, 3, 59, "Input"],
Cell[16177, 356, 305, 5, 56, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[16519, 366, 3132, 47, 859, "Input"],
Cell[19654, 415, 380, 5, 56, "Output"]
}, Open  ]],
Cell[20049, 423, 396, 7, 139, "Input"],

Cell[CellGroupData[{
Cell[20470, 434, 293, 6, 75, "Input"],
Cell[20766, 442, 180, 3, 41, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[20983, 450, 121, 2, 43, "Input"],
Cell[21107, 454, 179, 3, 41, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[21323, 462, 121, 2, 43, "Input"],
Cell[21447, 466, 179, 3, 41, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[21663, 474, 121, 2, 43, "Input"],
Cell[21787, 478, 179, 3, 41, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[22003, 486, 121, 2, 43, "Input"],
Cell[22127, 490, 179, 3, 41, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[22343, 498, 1084, 16, 283, "Input"],
Cell[23430, 516, 224, 3, 41, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[23691, 524, 72, 1, 27, "Input"],
Cell[23766, 527, 670, 10, 86, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[24473, 542, 143, 2, 43, "Input"],
Cell[24619, 546, 143, 2, 76, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[24799, 553, 45, 1, 27, "Input"],
Cell[24847, 556, 681, 10, 86, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[25565, 571, 58, 1, 27, "Input"],
Cell[25626, 574, 745, 13, 86, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[26408, 592, 60, 1, 27, "Input"],
Cell[26471, 595, 49, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[26557, 601, 58, 1, 27, "Input"],
Cell[26618, 604, 144, 2, 26, "Output"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

